clear

%Clay fragment radius
R=1; 

%Distance between circle bundaries
dc=5; 

% Distance between circle centers
dx=2*R+dc;
dy=2*R+dc;

%Mixing constant
m=0.5;


%Quick approximation
%_________________________________________________________________________________________

for u=0:1:1000

%number of points
n = 100;  
    
%vector of angles at which points are drawn
angle = 0:2*pi/n:2*pi;

%points on circle
x = (R*cos(angle));  y = (R*sin(angle)); 

%strain tensor
a=1;
b=0;
c=u;
d=1;

%ellipse after deformation
xdef=x*a+y*b; ydef=x*c+y*d;

%rotation of major-semi-axis
ALPHA=90+(atand((2*a*c+b*d)/(a^2+b^2-c^2-d^2)))/2;

%find length of major and minor semi-axis 
        %calculate distances from each point on ellipse to center
        dist=sqrt(xdef.^2+ydef.^2);
        %find maximum distance and position in vector for major semi-axis
        [dxmax,xmaxpos]=max(dist);
        %find x-value for major semi-axis
        xmax=xdef(xmaxpos);
        %find y-value for major semi-axis
        ymax=ydef(xmaxpos);
        %calculate length of major semi-axis
        lmax=sqrt(xmax^2+ymax^2);

        %find minimum distance and position in vector for minor semi-axis
        [dxmin,xminpos]=min(dist);
        %find x-value for minor semi-axis
        xmin=xdef(xminpos);
        %find y-value for minor semi-axis
        ymin=ydef(xminpos);
        %calculate length of minor semi-axis
        lmin=sqrt(xmin^2+ymin^2);
        
        
%increase size of ellipse by u*m
    xinc= (lmax+u*m)*cos(angle);
    yinc= (lmin+u*m)*sin(angle);

%rotate to original orientation
        %rotation matrix
        r1=cosd(ALPHA);
        r2=sind(ALPHA);
        r3=sind(ALPHA);
        r4=cosd(ALPHA);
        %rotation
        xrot=xinc*r1-yinc*r2;
        yrot=xinc*r3+yinc*r4;
        
%particles
% 1 -------------------------------------------
cx1 = 1;
cy1 = 1;
        x1=cx1+xdef; y1=-c*R+cy1+ydef;
        xinc1=cx1+xrot;
        yinc1=-c*R+cy1+yrot;   
        sx1=size(xinc1); sy1=size(yinc1);
% 2 -------------------------------------------
cx2 = 1;
cy2 = cy1+dy;
x2=cx2+xdef; y2=-c*R+cy2+ydef;
        xinc2=cx2+xrot;
        yinc2=-c*R+cy2+yrot;  
% 3 -------------------------------------------
cx3 = 1;
cy3 = cy2+dy;
x3=cx3+xdef; y3=-c*R+cy3+ydef;
        xinc3=cx3+xrot;
        yinc3=-c*R+cy3+yrot;  
% 4 -------------------------------------------
cx4 = cx1+dx;
cy4 = 1;
x4=cx4+xdef; y4=+c*R+cy4+ydef;
        xinc4=cx4+xrot;
        yinc4=+c*R+cy4+yrot;  
% 5 -------------------------------------------
cx5 = cx1+dx;
cy5 = cy4+dy;
x5=cx5+xdef; y5=+c*R+cy5+ydef;
        xinc5=cx5+xrot;
        yinc5=+c*R+cy5+yrot;  
% 6 -------------------------------------------
cx6 = cx1+dx;
cy6 = cy5+dy;
x6=cx6+xdef; y6=+c*R+cy6+ydef;
        xinc6=cx6+xrot;
        yinc6=+c*R+cy6+yrot;  

        
        
%find intersections
       for i=1:1:((sx1(2))-1)

X1=[xinc1(i) xinc1(i+1)];
Y1=[yinc1(i) yinc1(i+1)];


            for j=1:1:((sx1(2))-1)
         
        X2=[xinc2(j) xinc2(j+1)];
        Y2=[yinc2(j) yinc2(j+1)];

        X0=1;
        [X0,Y0] = intersections(X1,Y1,X2,Y2,true);

               if X0 ~= 0
                break
               else continue
               end
                
            end
            
       if X0 ~= 0
                break
       end     
       end
       
if X0 ~= 0
     break
end       
end

%precise calculation
%_________________________________________________________________________________________
for k=u-1:0.05:100

%number of points
n = 720;  

%vector of angles at which points are drawn
angle = 0:2*pi/n:2*pi;           

%circle
x = (R*cos(angle));  y = (R*sin(angle)); 

%strain tensor
a=1;
b=0;
c=k;
d=1;

%ellipse after deformation
xdef=x*a+y*b; ydef=x*c+y*d;

%rotation of major-semi-axis
ALPHA=90+(atand((2*a*c+b*d)/(a^2+b^2-c^2-d^2)))/2;

%find length of major and minor semi-axis 
        %calculate distances from each point on ellipse to center
        dist=sqrt(xdef.^2+ydef.^2);
        %find maximum distance and position in vector for major semi-axis
        [dxmax,xmaxpos]=max(dist);
        %find x-value for major semi-axis
        xmax=xdef(xmaxpos);
        %find y-value for major semi-axis
        ymax=ydef(xmaxpos);
        %calculate length of major semi-axis
        lmax=sqrt(xmax^2+ymax^2);

        %find minimum distance and position in vector for minor semi-axis
        [dxmin,xminpos]=min(dist);
        %find x-value for minor semi-axis
        xmin=xdef(xminpos);
        %find y-value for minor semi-axis
        ymin=ydef(xminpos);
        %calculate length of minor semi-axis
        lmin=sqrt(xmin^2+ymin^2);
        
        
%increase size of ellipse by u*m
    xinc= (lmax+k*m)*cos(angle);
    yinc= (lmin+k*m)*sin(angle);
%rotate to original orientation

        %rotation matrix
        r1=cosd(ALPHA);
        r2=sind(ALPHA);
        r3=sind(ALPHA);
        r4=cosd(ALPHA);
        %rotation
        xrot=xinc*r1-yinc*r2;
        yrot=xinc*r3+yinc*r4;

     
%particles--------------------------------------------------
%position of undeformed particle centers
cx1 = 1;
cy1 = 1;

cx2 = 1;
cy2 = cy1+dy;

cx3 = 1;
cy3 = cy2+dy;

cx5 = cx1+dx;
cy5 = cy4+dy;

cx6 = cx1+dx;
cy6 = cy5+dy;

% 1 -------------------------------------------
%deformed but not larger ellipse
x1=cx1+xdef; y1=-c*R+cy1+ydef; 
%deformed ellipse, increased size
        xinc1=cx1+xrot; yinc1=-c*R+cy1+yrot;   
        %number of elements in ellipse
        sx1=size(xinc1); sy1=size(yinc1);
% 2 -------------------------------------------

x2=cx2+xdef; y2=-c*R+cy2+ydef;
        xinc2=cx2+xrot; yinc2=-c*R+cy2+yrot;  
% 3 -------------------------------------------

x3=cx3+xdef; y3=-c*R+cy3+ydef;
        xinc3=cx3+xrot; yinc3=-c*R+cy3+yrot;  
% 4 -------------------------------------------
cx4 = cx1+dx;
cy4 = 1;
x4=cx4+xdef; y4=+c*R+cy4+ydef;
        xinc4=cx4+xrot; yinc4=+c*R+cy4+yrot;  
% 5 -------------------------------------------

x5=cx5+xdef; y5=+c*R+cy5+ydef;
        xinc5=cx5+xrot; yinc5=+c*R+cy5+yrot;  
% 6 -------------------------------------------

x6=cx6+xdef; y6=+c*R+cy6+ydef;
        xinc6=cx6+xrot;  yinc6=+c*R+cy6+yrot;  
disp(k)
% Find intersections
       for p=1:(sx1(2)/2)-1.5

X1=[xinc1(p) xinc1(p+1)];
Y1=[yinc1(p) yinc1(p+1)];

            for q=(sx1(2)/2)-0.5:sx1(2)-1
            
        X2=[xinc2(q) xinc2(q+1)];
        Y2=[yinc2(q) yinc2(q+1)];

        X0=1;
        [X0,Y0] = intersections(X1,Y1,X2,Y2,true);

               if X0 ~= 0
                break
               else continue
               end
                
            end
            
       if X0 ~= 0
                break
       end     
       end
       
if X0 ~= 0
     break
end       
end

%output shear strain
disp(k)

%plot
figure(2)
plot(x1,y1,xinc1,yinc1,x2,y2,xinc2,yinc2,x3,y3,xinc3,yinc3,x4,y4,xinc4,yinc4,x5,y5,xinc5,yinc5,x6,y6,xinc6,yinc6);           
axis equal tight
grid on;